/*
 * Decompiled with CFR 0.152.
 */
package net.yorunina.tetrajs.compat.tetra;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.yorunina.tetrajs.model.ItemEffectResult;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;

public class TetraEffect {
    public static ItemEffect getEffectOrCreate(String key) {
        return ItemEffect.get((String)key);
    }

    @Nullable
    public static ItemEffect[] getAllItemEffects(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modular = (ModularItem)item;
            return (ItemEffect[])modular.getEffects(stack).toArray(ItemEffect[]::new);
        }
        return null;
    }

    @Nullable
    public static ItemEffectResult[] getAllItemEffectResults(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modular = (ModularItem)item;
            return (ItemEffectResult[])modular.getEffects(stack).stream().map(effect -> {
                ItemEffectResult result = new ItemEffectResult();
                result.itemEffect = effect;
                result.level = modular.getEffectLevel(stack, effect);
                result.item = stack;
                return result;
            }).toArray(ItemEffectResult[]::new);
        }
        return null;
    }

    public static boolean hasItemEffect(ItemStack stack, ItemEffect effect) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modular = (ModularItem)item;
            return modular.getEffectLevel(stack, effect) > 0;
        }
        return false;
    }

    public static int getEffectLevel(ItemStack stack, ItemEffect effect) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modular = (ModularItem)item;
            return modular.getEffectLevel(stack, effect);
        }
        return 0;
    }

    public static double getEffectEfficiency(ItemStack stack, ItemEffect effect) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modular = (ModularItem)item;
            return modular.getEffectEfficiency(stack, effect);
        }
        return 0.0;
    }

    public static ItemEffect createItemEffect(ResourceLocation key) {
        return ItemEffect.get((String)key.toString());
    }
}

